# Vespucci 15.2 Highlights

2021-03-14

### Dedicated address mode and address handling improvements

When we introduced the "simple mode" in Vespucci 12 in 2019 there was no way to directly add address nodes without switching to the old element creation mode via long press (you could however add a node and then predict the address in the property editor). To make this a bit easier 15.2 introduces a dedicated "Address" mode that switches the "plus"-button to allow adding 
    
  - an address node (including automatically adding an entrance tag if the node is on a building outline)
  - an address interpolation
  - a map note
  
Further improvements include support for addr:block, addr:conscriptionnumber and addr:block_number in the address tags preference, and the use of information from [geocontext project](https://github.com/simonpoole/geocontext) for region specific default address tags.   

### Support mode specific launcher shortcuts

After adding a short cut for the "help" system in 15.1, we've added further short cuts for specific modes: Indoor, Tag-only and Address.

In launchers that support the functionality short cuts can be accessed by a long press on the app icon, and dragged to create short cut links for direct access.

### Support merging closed ways/polygons

Basic support for merging two closed ways/polygons has been added to the multi-select mode. If their are no common nodes, or if the function dedects inner rings this will create a multi-polygon, otherwise a single closed way. 

If a multi-polygon is created common tags from the outers will be moved to the multi-polygon relation, this is done in a separate undo changeset and can be reverted without undoing the polygon merge.

### Better detection and handling of empty relations

Creating empty relation objects is a harmless, but sometimes annoying side effect of other operations. Vespucci has detected these in a number of places prior to this release, 15.2 expands this to cover everywhere this can happen indirectly. Contrary to other editing apps behaviour we do not delete empty relations automatically (for example you may have just emptied one for re-use in a next step), but will prompt you for how to treat them.

To prevent accidental upload of empty relations they are now highlighted by the validator in the upload dialog. Additionally we've added an extension to our object search support that allows searching for relations with a specific number of members, see [JOSM filter expression parser project](https://github.com/simonpoole/JosmFilterParser).
   
### Support for creating OSM objects from GeoJson Features

Individual geometries in a GeoJSON layer can now be directly converted to OSM elements in the OSM data layer. Attributes of the geometries will be mapped to OSM tags.

Don't forget that any source used in this way needs to have compatible licence terms and, if you are planning on importing larger number of objects, you need to follow the [OSM import guidelines](https://wiki.openstreetmap.org/wiki/Import/Guidelines).

### Support node icons and flexible labeling in data styling

Previously the icon used to display a tagged node was retrieved from the best matching preset (if any), in 15.2 this can be overridden in the data style, just as the key that is used to label an object (default is the _name_ key). This allows more flexible icon and label selection using the data style hierarchical matching. Any other styling parameters for nodes is ignored outside of the internal node style values that can be set in the style. See [Vespucci data styling](http://vespucci.io/tutorials/data_styling/).

Further icons on closed ways are no longer hardwired but can be configured  just as above too. 

## Miscellaneous

* Show a disambiguation menu when multiple ways could be appended to
* Add preference UI for taginfo server URL
* Add support for ELI meta field and tests
* Add proper multi-polygon support for ELI
* Add support for selecting MultiLineString and GeometryCollection features in the GeoJSON layer
* Support multiple parse error messages from opening hours parser
* Support regular expressions in object search (JOSM filter expressions) 
* Support import of JOSM .osn and osmand .ocs files with Notes
* Improve task dialogs behaviour (Notes, OSMOSE etc)
* Keep way selected after rotation
* Suppress display of pre-element-creation state in info dialog
* Add preference for maximum distance to which we auto-apply a locally stored imagery offset
* Render tunnel=* for waterways
* Add option for changing extracted footway or similar segment to steps

# Upgrading from previous versions

* As a safety measure, you should always upload any changes before updating.

# Known problems

* The documentation is out of date.
* For other known problems with this build please see [our issue tracker](https://github.com/MarcusWolschon/osmeditor4android/issues)
